#  项目一 Selenium爬取淘宝

##  项目要求

1.能独立安装Selenium以及WebDriver。
2.能独立使用Selenium爬取网页数据。

## 学习目标：

1.掌握爬虫的概念。
2.了解Chrome浏览器的开发者工具。
3.了解自动化工具：Selenium。
4.掌握使用Python+Selenium爬取淘宝网的商品数据。

## 相关知识

### 1.爬虫

爬虫是一种通过自动化程序获取互联网上的数据的技术，也用于各种应用，如数据分析、信息收集。

### 2.Chrome浏览器以及开发者工具

#### （1）Chrome是一款由[Google](https://baike.baidu.com/item/Google/86964?fromModule=lemma_inlink)公司开发的[网页浏览器](https://baike.baidu.com/item/网页浏览器/8309940?fromModule=lemma_inlink)

<img src="../pic/chrome_icon.png" alt="chrome_icon" style="zoom:25%;"/>



![chrome_face](../pic\chrome_face.webp)

#### （2）浏览器开发者工具

##### a.如何调出开发者工具

打开浏览器后，键盘上按F12调出；
或者打开浏览器后，点击鼠标右键，选择检查调出，如下图：

<img src="../pic\浏览器开发者工具打开.png" alt="浏览器开发者工具打开" style="zoom:80%;" />

##### b.开发者工具介绍

浏览器器开发者工具最常用的四个功能模块：元素（ELements）、控制台（Console）、源代码（Sources），网络（Network）。

<img src="../pic\浏览器开发者工具界面.png" alt="浏览器开发者工具界面" style="zoom: 50%;" />



**元素（Elements）**：用于查看或修改HTML元素的属性、CSS属性、监听事件、断点等。css可以即时修改，即时显示。大大方便了开发者调试页面。

控制台（Console）：控制台一般用于执行一次性代码，查看JavaScript对象，查看调试日志信息或异常信息。还可以当作Javascript API查看用。例如我想查看console都有哪些方法和属性，我可以直接在Console中输入"console"并执行。

源代码（Sources）：该页面用于查看页面的HTML文件源代码、JavaScript源代码、CSS源代码，此外最重要的是可以调试JavaScript源代码，可以给JS代码添加断点等。

网络（Network）：网络页面主要用于查看header等与网络连接相关的信息。

### 3.HTML

网页是图片，链接，文字，声音，视频等元素组成的，其实就是一个HTML文件。
网页生成制作，是由前端人员书写HTML文件，然后经过浏览器渲染，点开浏览器就可以看到网页。
`HTML`：超文本标记语言，是用来制作网页的一门语言。由标签组成，例如，图片标签，链接标签，视频标签。

HTML语法规范和基本结构标签：

- HTML标签是由尖括号包围的关键词，例如< html>.
- HTML标签通常是成对出现的，例如，< html>和< /html>，我们称之为双标签。
- 有些特殊的标签必须是单个标签，例如< br />

每个网页都会有一个基本结构标签
![html结构](../pic\html结构.png)

| 标签名   | 说明                                                   |
| -------- | ------------------------------------------------------ |
| < html>  | 页面中最大的标签，我们称之为根标签                     |
| < head>  | 注意在head标签中我们必须要设置的标签是title            |
| < title> | 让页面拥有一个属于自己的网页标题                       |
| < body>  | 元素包含文档的所有内容，页面内容基本都是放到body里面的 |

使用开发者工具查看网页的html结构,如下图

<img src="../pic\html.png" alt="html" style="zoom:80%;" />

### 4.Selenium

Selenium是一个web的自动化工具，最初是为网站自动化测试而开发的，Selenium可以直接运行在浏览器上，它支持所有主流的浏览器，可以接收指令，让浏览器自动加载页面，获取需要的数据。	



## 操作步骤

### 步骤1：配置环境

（1）安装chrome，版本为114.0.5735，安装包目录为：data\114.0.5735.199_chrome_installer.exe

<img src="../pic\chrome安装.png" alt="chrome安装" style="zoom:50%;" />

（2）在data文件夹中找到chromedriver.exe，把路径记录下来如： C:\Users\Admin\Desktop\selenium爬取淘宝\data\chromedriver_win32\chromedriver.exe，后续写python代码时需要使用

注：如果使用的chrome浏览器版本不是114.0.5735，需要先把原来的chrome卸载后重新安装

<img src="../pic\webdriver安装.png" alt="webdriver安装" style="zoom:50%;" />

（3）python安装selenium库

```
pip install seleniume
```



### 步骤2：使用webdriver打开浏览器

```python
from selenium import webdriver
from selenium.webdriver.chrome.service import Service
from selenium.webdriver.common.by import By

# 步骤一中记录下的webdriver.exe的路径
web_driver_path = r"C:\Users\Admin\Desktop\selenium爬取淘宝\data\chromedriver_win32\chromedriver.exe"

browser = webdriver.Chrome(service=Service(executable_path=web_driver_path))

```

执行上面的代码，留意电脑屏幕下方的图标，这时会出现一个新的chrome浏览器小图标，这个新打开的浏览器就是上面代码的browser

<img src="../pic\运行webdriver.png" alt="运行webdriver" style="zoom:50%;" />

<img src="../pic\selenium打开浏览器.png" alt="selenium打开浏览器" style="zoom:50%;" />

### 步骤3： 使用selenium打开淘宝网

```python
# 淘宝网的链接地址URL
URL = 'https://www.taobao.com/'
# 浏览器中打开淘宝网
browser.get(url=URL)
```

<img src="../pic\selenium打开淘宝网.png" alt="selenium打开淘宝网" style="zoom:50%;" />

### 步骤4：用自己的账号登录淘宝，在搜索栏中输入“书包”

<img src="../pic\淘宝登录.png" alt="淘宝登录" style="zoom:50%;" />

<img src="../pic\淘宝搜索.png" alt="淘宝搜索" style="zoom: 50%;" />

### 步骤5：爬取第一个商品

(1)键盘F12  或者   鼠标右键->检查， 打开开发者工具

![淘宝中打开开发者工具](../pic\淘宝中打开开发者工具.png)

（2）在开发者工具中找到Elements(中文叫“元素”)，就能看到网页的html结构了。

![image-20240125155613288](../pic\淘宝elements.png)

（3）开发者工具定位一个商品的名称：在开发者工具的左上方，点击下图中的符号后，鼠标移动到商品的名称那里

![淘宝定位商品](../pic\淘宝定位商品.png)

开发者工具中，点代码中的那个三角符号展开代码，可以看到代码中包含了商品的名字。确定这个数据就是要爬取的内容。

![image-20240125160601077](../pic\淘宝定位商品2.png)

（4）鼠标向上找一点点，找到这个标签的class名字（即<div class="Title--title--jCOPvpf">），把名字拷贝下来"Title--title--jCOPvpf"

![淘宝定位class](../pic\淘宝定位class.png)

（5）把定位到的class名字写到代码中

```
# 调用find_element函数
ele = browser.find_element(By.CLASS_NAME,"Title--title--jCOPvpf")
print(ele.text)
```

运行代码，查看输出结果： “男士双肩包男款背包2023新款旅游旅行大容量男大学生初中高中”

### 步骤6：爬取多个商品

步骤5中，已经可以爬取到一个商品的名字了，接下来把爬取多个商品的名字

（1）移动鼠标，找到这个商品的代码。从之前找到的中文开始，鼠标在开发者工具代码中向上移动，网页会出现浅蓝色方框表示该代码指向的网页内容。网站代码比较复杂，可以把鼠标移动到有三角符号的那行，然后一层一层往上移动，移动后，点击三角符号把代码收缩起来。

<img src="../pic\淘宝寻找元素.png" alt="淘宝寻找元素" style="zoom:80%;" />

（2）当网页中所有商品变成蓝色后，就找到了包含所有商品的结构

![淘宝多个商品定位](../pic\淘宝多个商品定位.png)

（3）确认上图中每个div对应一个商品，把代码打开，查看每个商品，表示名称的都是<div class="Title--title--jCOPvpf">

![淘宝第二个商品](../pic\淘宝第二个商品.png)

（4）编写代码

```
# find_element函数是找一个
# find_elements函数是找多个，返回列表
# 调用find_elements函数
ele_list = browser.find_elements(By.CLASS_NAME,"Title--title--jCOPvpf")
for e in ele_list:
	print(e.text)
```

输出结果：

```
男士双肩包男款背包2023新款旅游旅行大容量男大学生初中高中
书包初中女生高中学生背包小学生大学生旅行双肩包大容量轻便新款
旅行背包男士双肩包2023新款轻便休闲出差旅游行李大容量电脑
书包女生高中生背包初中生大学生小学生大容量旅行双肩包男电脑包
双肩包男士大容量商务电脑旅行背包2023新款女防水初中大学生
新款休闲旅行包时尚背包男士双肩包高中生大学生运动登山包
男生书包初中生小学生男童三到六大容量一年级减负护脊五2023新款
爱迪生女初中生减负护脊新款大容量双肩包高中生防水背包男生
旅行背包男士双肩包休闲短途商务出差旅游行李包大容量电脑女
双肩包男士休闲简约背包ins日系时尚潮流短途出差旅行包学生
...
```



## 项目总结：

  将学习到的爬虫的理论知识落实在实践上，学会编写程序从网页上爬取数据。通过使用python+selenium+chrome，成功爬取到淘宝网上商品的名称。

## 作业练习：

从淘宝网上爬取一页商品的价格。

